/*****************************************************/
/* Examples Program For "ET-ARM7 BASE LPC2106" Board */
/* Target MCU  : Philips ARM7-LPC2106                */
/*       	   : X-TAL : 19.6608 MHz                 */
/*             : Run Speed 58.9824MHz (With PLL)     */
/* Keil Editor : uVision3 V3.03a                     */
/* Compiler    : Keil CARM V2.50a		             */
/* Create By   : Eakachai Makarn (WWW.ETT.CO.TH)     */
/* Last Update : 17/April/2006                       */
/* Function    : Example Use GPIO-0	on Output Mode   */
/*             : LED Moving on GPIO-0(31 <------> 2) */	
/*****************************************************/

#include <LPC210x.H> 	                                	// LPC2106 MPU Register

/* pototype  section */
void delay_led(unsigned long int);							// Delay Time Function

int main(void)
{
  unsigned long int LED; 									// LED Output Status Buffer

  // Initial all GPIO-0 = Output
  // Reserve P0.0 = TXD(UART0)
  // Reserve P0.1 = RXD(UART0)
  // [xxxx xxxx xxxx xxxx xxxx xxxx xxxx xx--]    
  PINSEL0 = 0x00000000;										// Makesure GPIO0[00..15] = GPIO Function
  PINSEL1 = 0x00000000;										// Makesure GPIO0[16..31] = GPIO Function
  IODIR   = 0xFFFFFFFC; 						         	// Set all GPIO-0[02..31] = Output
  IOSET   = 0xFFFFFFFC;                                  	// Set all GPIO-0 Output Pin(OFF LED)  
 
  // Loop Test Output GPI0-0 //
  while(1)													// Loop Continue
  {    	
	// GPIO0.31 <-- GPIO0.2
    for (LED = 0x00000004; LED < 0x80000000; LED <<= 1)		// Shift Left GPIO-0 (Right <- Left)
    { 
	  IOCLR = LED;											// Clear Output Pin (ON LED)
      delay_led(10000000);									// Display Delay
	  IOSET = LED;                                   		// Set Output Pin (OFF LED)	  
    }  
	  
	// GPIO0.31 ---> GPIO0.2
	for (LED = 0x80000000; LED > 0x00000004; LED >>= 1)		// Shift Right GPIO-0(Right -> Left)
    { 
	  IOCLR = LED;											// Clear Output Pin (ON LED)
      delay_led(10000000);									// Display Delay
	  IOSET = LED;                                   		// Set Output Pin (OFF LED)
    }  	  
  }   
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay_led(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}


